--> Pralable
/*
IF EXISTS(SELECT NULL FROM sys.databases WHERE name = 'DB_CRYPT')
BEGIN
   EXEC ('USE DB_CRYPT;
          ALTER DATABASE DB_CRYPT SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
          USE master;
          DROP DATABASE DB_CRYPT;');
END;

*/
-- USE master;

-- On cre une base de donnes
CREATE DATABASE DB_CRYPT
GO
-- On se place dans le contexte de cette nouvelle base
USE DB_CRYPT
GO
-- On cre une table des patients
CREATE TABLE dbo.T_PATIENT_PTT
(PTT_ID               INT IDENTITY PRIMARY KEY,
 PTT_NOM_CRYPTE       VARBINARY(256), 
 PTT_NUMSECU_CRYPTE   VARBINARY(128));
GO
-- On cre un certificat afin de crypter des donnes
CREATE CERTIFICATE CRT_SECRET
   ENCRYPTION BY PASSWORD = '1 ceux CRAIE'
   WITH SUBJECT = 'cryptage des donnes de sant',
        EXPIRY_DATE = '20201231';
-- On insre les donnes cryptes par certificat
INSERT INTO dbo.T_PATIENT_PTT
VALUES (ENCRYPTBYCERT(CERT_ID('CRT_SECRET'), 'Dupont'),
        ENCRYPTBYCERT(CERT_ID('CRT_SECRET'), '1800675112337'));
-- On dcrypte les donnes dans une requte dextraction de donnes
SELECT *,
       CAST(DECRYPTBYCERT(CERT_ID('CRT_SECRET'),
       PTT_NOM_CRYPTE, N'1 ceux CRAIE') AS VARCHAR(32)),
       CAST(DECRYPTBYCERT(CERT_ID('CRT_SECRET'),
       PTT_NUMSECU_CRYPTE, N'1 ceux CRAIE') AS CHAR(13))
FROM   dbo.T_PATIENT_PTT;
